using System;
using System.Diagnostics;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Data.SqlClient;

namespace DataView_Find_Array {
    /// <summary>
    /// Summary description for Form1.
    /// </summary>
    public class Form1 : System.Windows.Forms.Form {
        private SqlConnection cn; 
        private SqlCommand cmdCust;
        private SqlCommand cmdOrderItem;
        private SqlDataAdapter daCust;
        private SqlDataAdapter daOrderItem;
        private DataSet dsCust; 
        private DataSet dsOrderItem; 
        private int  i;
        private object objDb; 
        private bool bolSetup;

        internal System.Windows.Forms.TextBox txtFoundRow;
        internal System.Windows.Forms.TextBox txtOrderID;
        internal System.Windows.Forms.Button btnFind;
        internal System.Windows.Forms.Label Label1;
        internal System.Windows.Forms.ComboBox cmbCustList;
        internal System.Windows.Forms.DataGrid DataGrid1;
        internal System.Windows.Forms.Button btnFindArray;
        internal System.Windows.Forms.Label Label2;
        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.Container components = null;

        public Form1() {
            try {
                //
                // Required for Windows Form Designer support
                //
                InitializeComponent();

                //
                // TODO: Add any constructor code after InitializeComponent call
                //
                cn = new SqlConnection("server=.;database=biblio;uid=admin;pwd=pw");
                cmdCust = new SqlCommand("GetcustomerByState",cn);
                cmdCust.CommandType = CommandType.StoredProcedure;
                cmdCust.Parameters.Add("@ZipWanted", SqlDbType.VarChar, 12).Value = "15327"; // Lots of customers here
                cmdCust.Parameters.Add("@NameHint", SqlDbType.VarChar, 20).Value = "%";

                cmdOrderItem = new SqlCommand("GetOrdersByCustomer",cn);
                cmdOrderItem.CommandType =  CommandType.StoredProcedure;
                cmdOrderItem.Parameters.Add("@CustIDWanted", SqlDbType.Int);
                daCust = new SqlDataAdapter(cmdCust);
                daOrderItem =new SqlDataAdapter(cmdOrderItem);
                dsCust = new DataSet();
                dsOrderItem= new DataSet();
                bolSetup = true;
                daCust.Fill(dsCust, "Customers");
                dsCust.Tables[0].DefaultView.Sort = "CustID" ;
                cmbCustList.DataSource = dsCust.Tables[0];
                cmbCustList.DisplayMember = "CustID";
                RunQuery();
                objDb = DataGrid1.DataSource;
            }
            catch (Exception ex) {
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }

            bolSetup = false;
        }

        private void RunQuery() {
            try {
                cmdOrderItem.Parameters["@CustIDWanted"].Value = Convert.ToInt32(cmbCustList.Text);
                dsOrderItem.Clear();
                daOrderItem.Fill(dsOrderItem, "OrderItem");
                DataGrid1.DataSource = dsOrderItem.Tables[0];
            }
            catch (Exception ex) {
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());

            }
        }



        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose( bool disposing ) {
            if( disposing ) {
                if (components != null) {
                    components.Dispose();
                }
            }
            base.Dispose( disposing );
        }

#region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent() {
            this.txtFoundRow = new System.Windows.Forms.TextBox();
            this.txtOrderID = new System.Windows.Forms.TextBox();
            this.btnFind = new System.Windows.Forms.Button();
            this.Label1 = new System.Windows.Forms.Label();
            this.cmbCustList = new System.Windows.Forms.ComboBox();
            this.DataGrid1 = new System.Windows.Forms.DataGrid();
            this.btnFindArray = new System.Windows.Forms.Button();
            this.Label2 = new System.Windows.Forms.Label();
            ((System.ComponentModel.ISupportInitialize)(this.DataGrid1)).BeginInit();
            this.SuspendLayout();
            // 
            // txtFoundRow
            // 
            this.txtFoundRow.Location = new System.Drawing.Point(144, 88);
            this.txtFoundRow.Name = "txtFoundRow";
            this.txtFoundRow.Size = new System.Drawing.Size(560, 20);
            this.txtFoundRow.TabIndex = 20;
            this.txtFoundRow.Text = "";
            // 
            // txtOrderID
            // 
            this.txtOrderID.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.txtOrderID.Location = new System.Drawing.Point(176, 40);
            this.txtOrderID.Name = "txtOrderID";
            this.txtOrderID.RightToLeft = System.Windows.Forms.RightToLeft.Yes;
            this.txtOrderID.Size = new System.Drawing.Size(128, 22);
            this.txtOrderID.TabIndex = 18;
            this.txtOrderID.Text = "";
            // 
            // btnFind
            // 
            this.btnFind.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.btnFind.Location = new System.Drawing.Point(16, 88);
            this.btnFind.Name = "btnFind";
            this.btnFind.Size = new System.Drawing.Size(96, 24);
            this.btnFind.TabIndex = 17;
            this.btnFind.Text = "Find";
            this.btnFind.Click += new System.EventHandler(this.btnFind_Click);
            // 
            // Label1
            // 
            this.Label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.Label1.Location = new System.Drawing.Point(16, 16);
            this.Label1.Name = "Label1";
            this.Label1.Size = new System.Drawing.Size(96, 24);
            this.Label1.TabIndex = 14;
            this.Label1.Text = "CustID";
            // 
            // cmbCustList
            // 
            this.cmbCustList.DropDownWidth = 152;
            this.cmbCustList.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.cmbCustList.Location = new System.Drawing.Point(16, 40);
            this.cmbCustList.Name = "cmbCustList";
            this.cmbCustList.RightToLeft = System.Windows.Forms.RightToLeft.Yes;
            this.cmbCustList.Size = new System.Drawing.Size(152, 24);
            this.cmbCustList.TabIndex = 13;
            this.cmbCustList.SelectedIndexChanged += new System.EventHandler(this.cmbCustList_SelectedIndexChanged);
            // 
            // DataGrid1
            // 
            this.DataGrid1.DataMember = "";
            this.DataGrid1.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.DataGrid1.HeaderForeColor = System.Drawing.SystemColors.ControlText;
            this.DataGrid1.Location = new System.Drawing.Point(0, 189);
            this.DataGrid1.Name = "DataGrid1";
            this.DataGrid1.Size = new System.Drawing.Size(736, 288);
            this.DataGrid1.TabIndex = 19;
            // 
            // btnFindArray
            // 
            this.btnFindArray.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.btnFindArray.Location = new System.Drawing.Point(16, 128);
            this.btnFindArray.Name = "btnFindArray";
            this.btnFindArray.Size = new System.Drawing.Size(96, 24);
            this.btnFindArray.TabIndex = 16;
            this.btnFindArray.Text = "Find Array";
            this.btnFindArray.Click += new System.EventHandler(this.btnFindArray_Click);
            // 
            // Label2
            // 
            this.Label2.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.Label2.Location = new System.Drawing.Point(176, 16);
            this.Label2.Name = "Label2";
            this.Label2.Size = new System.Drawing.Size(136, 24);
            this.Label2.TabIndex = 15;
            this.Label2.Text = "OrderID";
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(736, 477);
            this.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                          this.txtFoundRow,
                                                                          this.txtOrderID,
                                                                          this.btnFind,
                                                                          this.Label1,
                                                                          this.cmbCustList,
                                                                          this.DataGrid1,
                                                                          this.btnFindArray,
                                                                          this.Label2});
            this.Name = "Form1";
            this.Text = "Form1";
            ((System.ComponentModel.ISupportInitialize)(this.DataGrid1)).EndInit();
            this.ResumeLayout(false);

        }
#endregion

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main() {
            Application.Run(new Form1());
        }

        private void cmbCustList_SelectedIndexChanged(object sender, System.EventArgs e) {
            try{
                if (bolSetup) return;
                RunQuery();
            }
            catch (Exception ex) {
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }

        }

        private void btnFind_Click(object sender, System.EventArgs e) {
            try {
                DataRow drFound;
                DataColumn[] colPk = new DataColumn[2];
                colPk[0] = dsOrderItem.Tables[0].Columns["CustID"];
                colPk[1] = dsOrderItem.Tables[0].Columns["OrderID"];
                dsOrderItem.Tables[0].PrimaryKey = colPk;

                object[] objFind = new object[2];
                objFind[0] = cmbCustList.Text;
                objFind[1] = txtOrderID.Text;
                drFound = dsOrderItem.Tables[0].Rows.Find(objFind);
                if (drFound == null) {
                    MessageBox.Show("No PK matches search arguments");
                }
                else {
                    string strData="";
                    for (int i = 0; i<= drFound.ItemArray.GetUpperBound(0); i++) {
                        strData = strData + drFound[i].ToString() + " ";
                    }
                    txtFoundRow.Text = strData;
                }
            }
            catch(Exception ex) {
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }
        }

        private void btnFindArray_Click(object sender, System.EventArgs e) {
            try {
                int intRow;
                object[] objPkArgs = new object[2];
                objPkArgs[0] = cmbCustList.Text;
                objPkArgs[1] = txtOrderID.Text;
                dsOrderItem.Tables[0].DefaultView.Sort = "CustID, OrderID";
                intRow = dsOrderItem.Tables[0].DefaultView.Find(objPkArgs) ;
                Debug.WriteLine(intRow);
                if (intRow == -1) {
                    MessageBox.Show("No PK matches ");
                }
                else {
                    DataGrid1.CurrentRowIndex = intRow;
                }
            }
            catch(Exception ex) {
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }
        }
    }
}